#!/usr/bin/python

import os, time

starttime = time.strftime('%X %x %Z')

xslfile = "merge.xsl"
inputdir = "normalized"
outputdir = "merged"

buildsetupstring="""
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="outputmode" select="'merged'"/>
  <xsl:variable name="outputdir" select="'merged'"/>
</xsl:stylesheet>
"""

setupfile = file("setupbuild.xsl","w")
setupfile.write(buildsetupstring)
setupfile.close()

if os.path.exists("merged"):
    command = "rmdir /s /q merged"
    os.system(command)

command = "mkdir merged"
os.system(command)

for file in os.listdir(inputdir):
    if os.path.isfile(os.path.join(inputdir, file)):
        command = "saxon -w0 " + inputdir + '/' + file + ' ' + xslfile + \
                  " > " + outputdir + '/' + file
        os.system(command)
    
